-- Ask file path if no file was dragged
try
	set tmp to filePath
on error
	set filePath to choose file with prompt "Please select an image file."
end try


-- Get Original Size
tell application "Image Events"
	set anImage to open filePath
	copy dimensions of anImage to {w, h}
	if w is less than h then
		set the newSize to h
	else
		set the newSize to w
	end if
end tell


-- Ask new Size
repeat
	try
		display dialog "Enter the desired dimension (in pixels) of the longest side of the image:" default answer newSize
		set newSize to the text returned of the result as integer
		if newSize is greater than or equal to 1 then
			exit repeat
		end if
	on error number error_number
		if the error_number is -128 then
			return "user cancelled"
		end if
	end try
end repeat


-- Resize
tell application "Image Events"
	scale anImage to size newSize
	save anImage in filePath
	close anImage
end tell